/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeCheckerStateKt;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.ArgumentList;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentListMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OverridingUtilTypeSystemContext
implements ClassicTypeSystemContext {
    @Nullable
    private final Map<TypeConstructor, TypeConstructor> matchingTypeConstructors;
    @NotNull
    private final KotlinTypeChecker.TypeConstructorEquality equalityAxioms;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    @NotNull
    private final KotlinTypePreparator kotlinTypePreparator;
    @Nullable
    private final Function2<KotlinType, KotlinType, Boolean> customSubtype;

    public OverridingUtilTypeSystemContext(@Nullable Map<TypeConstructor, ? extends TypeConstructor> matchingTypeConstructors, @NotNull KotlinTypeChecker.TypeConstructorEquality equalityAxioms, @NotNull KotlinTypeRefiner kotlinTypeRefiner, @NotNull KotlinTypePreparator kotlinTypePreparator, @Nullable Function2<? super KotlinType, ? super KotlinType, Boolean> customSubtype) {
        Intrinsics.checkNotNullParameter(equalityAxioms, "equalityAxioms");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        Intrinsics.checkNotNullParameter(kotlinTypePreparator, "kotlinTypePreparator");
        this.matchingTypeConstructors = matchingTypeConstructors;
        this.equalityAxioms = equalityAxioms;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.customSubtype = customSubtype;
    }

    @Override
    public boolean areEqualTypeConstructors(@NotNull TypeConstructorMarker c1, @NotNull TypeConstructorMarker c2) {
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(c2, "c2");
        if (!(c1 instanceof TypeConstructor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(c2 instanceof TypeConstructor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return ClassicTypeSystemContext.DefaultImpls.areEqualTypeConstructors(this, c1, c2) || this.areEqualTypeConstructorsByAxioms((TypeConstructor)c1, (TypeConstructor)c2);
    }

    @Override
    @NotNull
    public TypeCheckerState newTypeCheckerState(boolean errorTypesEqualToAnything, boolean stubTypesEqualToAnything, boolean dnnTypesEqualToFlexible) {
        if (this.customSubtype == null) {
            KotlinTypeRefiner kotlinTypeRefiner = this.kotlinTypeRefiner;
            KotlinTypePreparator kotlinTypePreparator = this.kotlinTypePreparator;
            return ClassicTypeCheckerStateKt.createClassicTypeCheckerState(errorTypesEqualToAnything, stubTypesEqualToAnything, this, kotlinTypePreparator, kotlinTypeRefiner);
        }
        KotlinTypePreparator kotlinTypePreparator = this.kotlinTypePreparator;
        KotlinTypeRefiner kotlinTypeRefiner = this.kotlinTypeRefiner;
        return new TypeCheckerState(errorTypesEqualToAnything, stubTypesEqualToAnything, dnnTypesEqualToFlexible, this, kotlinTypePreparator, kotlinTypeRefiner){
            final /* synthetic */ OverridingUtilTypeSystemContext this$0;
            {
                this.this$0 = $receiver;
                super($errorTypesEqualToAnything, $stubTypesEqualToAnything, $dnnTypesEqualToFlexible, true, $receiver, $super_call_param$1, $super_call_param$2);
            }

            public boolean customIsSubtypeOf(KotlinTypeMarker subType, KotlinTypeMarker superType) {
                Intrinsics.checkNotNullParameter(subType, "subType");
                Intrinsics.checkNotNullParameter(superType, "superType");
                if (!(subType instanceof KotlinType)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(superType instanceof KotlinType)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return (Boolean)OverridingUtilTypeSystemContext.access$getCustomSubtype$p(this.this$0).invoke(subType, superType);
            }
        };
    }

    private final boolean areEqualTypeConstructorsByAxioms(TypeConstructor a, TypeConstructor b) {
        if (this.equalityAxioms.equals(a, b)) {
            return true;
        }
        if (this.matchingTypeConstructors == null) {
            return false;
        }
        TypeConstructor img1 = this.matchingTypeConstructors.get(a);
        TypeConstructor img2 = this.matchingTypeConstructors.get(b);
        return img1 != null && Intrinsics.areEqual(img1, b) || img2 != null && Intrinsics.areEqual(img2, a);
    }

    public static final /* synthetic */ Function2 access$getCustomSubtype$p(OverridingUtilTypeSystemContext $this) {
        return $this.customSubtype;
    }

    @NotNull
    public KotlinTypeMarker default$makeNullable(KotlinTypeMarker $this$makeNullable) {
        Intrinsics.checkNotNullParameter($this$makeNullable, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$makeNullable);
        return rigidTypeMarker != null && (rigidTypeMarker = this.withNullability(rigidTypeMarker, true)) != null ? (KotlinTypeMarker)rigidTypeMarker : $this$makeNullable;
    }

    @Nullable
    public CapturedTypeMarker default$asCapturedTypeUnwrappingDnn(RigidTypeMarker $this$asCapturedTypeUnwrappingDnn) {
        Intrinsics.checkNotNullParameter($this$asCapturedTypeUnwrappingDnn, "<this>");
        return this.asCapturedType(this.originalIfDefinitelyNotNullable($this$asCapturedTypeUnwrappingDnn));
    }

    public boolean default$isCapturedType(KotlinTypeMarker $this$isCapturedType) {
        Intrinsics.checkNotNullParameter($this$isCapturedType, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isCapturedType);
        return (rigidTypeMarker != null ? this.asCapturedTypeUnwrappingDnn(rigidTypeMarker) : null) != null;
    }

    @NotNull
    public SimpleTypeMarker default$originalIfDefinitelyNotNullable(RigidTypeMarker $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter($this$originalIfDefinitelyNotNullable, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asDefinitelyNotNullType($this$originalIfDefinitelyNotNullable);
        if (rigidTypeMarker == null || (rigidTypeMarker = this.original((DefinitelyNotNullTypeMarker)rigidTypeMarker)) == null) {
            rigidTypeMarker = (SimpleTypeMarker)$this$originalIfDefinitelyNotNullable;
        }
        return rigidTypeMarker;
    }

    @NotNull
    public KotlinTypeMarker default$makeDefinitelyNotNullOrNotNull(KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull, false);
    }

    @Nullable
    public TypeArgumentMarker default$getArgumentOrNull(RigidTypeMarker $this$getArgumentOrNull, int index) {
        Intrinsics.checkNotNullParameter($this$getArgumentOrNull, "<this>");
        boolean bl = 0 <= index ? index < this.argumentsCount($this$getArgumentOrNull) : false;
        if (bl) {
            return this.getArgument($this$getArgumentOrNull, index);
        }
        return null;
    }

    @NotNull
    public RigidTypeMarker default$lowerBoundIfFlexible(KotlinTypeMarker $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$lowerBoundIfFlexible, "<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$lowerBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.lowerBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$lowerBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull(rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    @NotNull
    public RigidTypeMarker default$upperBoundIfFlexible(KotlinTypeMarker $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$upperBoundIfFlexible, "<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$upperBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.upperBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$upperBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull(rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    public boolean default$isFlexibleWithDifferentTypeConstructors(KotlinTypeMarker $this$isFlexibleWithDifferentTypeConstructors) {
        Intrinsics.checkNotNullParameter($this$isFlexibleWithDifferentTypeConstructors, "<this>");
        return !Intrinsics.areEqual(this.typeConstructor(this.lowerBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)), this.typeConstructor(this.upperBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)));
    }

    public boolean default$isFlexible(KotlinTypeMarker $this$isFlexible) {
        Intrinsics.checkNotNullParameter($this$isFlexible, "<this>");
        return this.asFlexibleType($this$isFlexible) != null;
    }

    public boolean default$isDynamic(KotlinTypeMarker $this$isDynamic) {
        Intrinsics.checkNotNullParameter($this$isDynamic, "<this>");
        FlexibleTypeMarker flexibleTypeMarker = this.asFlexibleType($this$isDynamic);
        return (flexibleTypeMarker != null ? this.asDynamicType(flexibleTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(KotlinTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isDefinitelyNotNullType);
        return (rigidTypeMarker != null ? this.asDefinitelyNotNullType(rigidTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(RigidTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        return this.asDefinitelyNotNullType($this$isDefinitelyNotNullType) != null;
    }

    public boolean default$hasFlexibleNullability(KotlinTypeMarker $this$hasFlexibleNullability) {
        Intrinsics.checkNotNullParameter($this$hasFlexibleNullability, "<this>");
        return this.isMarkedNullable(this.lowerBoundIfFlexible($this$hasFlexibleNullability)) != this.isMarkedNullable(this.upperBoundIfFlexible($this$hasFlexibleNullability));
    }

    @NotNull
    public TypeConstructorMarker default$typeConstructor(KotlinTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter($this$typeConstructor, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$typeConstructor);
        if (rigidTypeMarker == null) {
            rigidTypeMarker = this.lowerBoundIfFlexible($this$typeConstructor);
        }
        return this.typeConstructor(rigidTypeMarker);
    }

    public boolean default$isNothing(KotlinTypeMarker $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return this.isNothingConstructor(this.typeConstructor($this$isNothing)) && !this.isNullableType($this$isNothing);
    }

    public boolean default$isClassType(RigidTypeMarker $this$isClassType) {
        Intrinsics.checkNotNullParameter($this$isClassType, "<this>");
        return this.isClassTypeConstructor(this.typeConstructor($this$isClassType));
    }

    @Nullable
    public List<SimpleTypeMarker> default$fastCorrespondingSupertypes(RigidTypeMarker $this$fastCorrespondingSupertypes, TypeConstructorMarker constructor) {
        Intrinsics.checkNotNullParameter($this$fastCorrespondingSupertypes, "<this>");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        return null;
    }

    public boolean default$isIntegerLiteralType(RigidTypeMarker $this$isIntegerLiteralType) {
        Intrinsics.checkNotNullParameter($this$isIntegerLiteralType, "<this>");
        return this.isIntegerLiteralTypeConstructor(this.typeConstructor($this$isIntegerLiteralType));
    }

    @NotNull
    public TypeArgumentMarker default$get(TypeArgumentListMarker $this$get, int index) {
        TypeArgumentMarker typeArgumentMarker;
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$get;
        if (typeArgumentListMarker instanceof SimpleTypeMarker) {
            typeArgumentMarker = this.getArgument((KotlinTypeMarker)((Object)$this$get), index);
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            Object e = ((ArgumentList)$this$get).get(index);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            typeArgumentMarker = (TypeArgumentMarker)e;
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$get + ", " + Reflection.getOrCreateKotlinClass($this$get.getClass())).toString());
        }
        return typeArgumentMarker;
    }

    public int default$size(TypeArgumentListMarker $this$size) {
        int n;
        Intrinsics.checkNotNullParameter($this$size, "<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$size;
        if (typeArgumentListMarker instanceof RigidTypeMarker) {
            n = this.argumentsCount((KotlinTypeMarker)((Object)$this$size));
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            n = ((ArgumentList)$this$size).size();
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$size + ", " + Reflection.getOrCreateKotlinClass($this$size.getClass())).toString());
        }
        return n;
    }
}

